function [] = movie_selfmade( DataKin, Title, COM_subjtrial, setting_cell, varargin)
%MOVIE_SELFMADE Summary of this function goes here
%   Detailed explanation goes here
        
x_y_z_setting   = setting_cell{2};
coloring_option = setting_cell{3};    
Path            = setting_cell{6};    
vid_dim         = setting_cell{7};
skipFrames      = setting_cell{10};
TransformOption = setting_cell{11};

n_Markers  = size(DataKin,2)/3;




if skipFrames ~= 1
    fprintf('\n\n        Skip Frames == %d (In "movie_selfmade")', skipFrames)
    msgbox(sprintf('Skip Frames == %d (In "movie_selfmade")', skipFrames))
else
    skipFrames = 1;
end




% % Center AP and ML directions for plotting
% DataKin(:,1:3:end-2) = DataKin(:,1:3:end-2)-mean(COM_subjtrial(:,1),1);
% DataKin(:,2:3:end-1) = DataKin(:,2:3:end-1)-mean(COM_subjtrial(:,2),1);

% Extra plot options
enable_COM = 0;
plotForcePlate = 0;
if nargin == 8
    COPdat = varargin{1};
    % Center AP and ML directions for plotting (CAREFUL WITH SIGN! sometimes FD or ML directions do not coincide!!)
    COM_subjtrial(:,1) = +(COM_subjtrial(:,1)-mean(COM_subjtrial(:,1),1));
    COM_subjtrial(:,2) = +(COM_subjtrial(:,2)-mean(COM_subjtrial(:,2),1));
    COPdat(:,1) = -(COPdat(:,1)-mean(COPdat(:,1),1)); % Bipedal stance had inverse FD directions
    COPdat(:,2) = +(COPdat(:,2)-mean(COPdat(:,2),1));
end

PathVid = fullfile(Path, 'Original motion');
A = exist(PathVid, 'dir');
if A == 7
else
    mkdir(PathVid);
end

Movie_filename = fullfile(PathVid,[Title,'.avi']);
writerObj = VideoWriter(Movie_filename);
open(writerObj);


%% Transform data back o carthesian coordinates if previously transformed
if TransformOption{1,1}
    fprintf('\n\n        Coordinate Transformation activated!');
    [DataKin, ~] = optionsTransformData(DataKin, TransformOption{1,2}, 2); % 2: Back transform to Cartesian coordinates
else
end

fprintf('\n')
 
%% Set x, y, z axes
permutation_vector = 1:n_Markers*3;
if x_y_z_setting == 1 % nothing
    fprintf('\n        Axes setting: %d (x,y,z) = (1,2,3)', x_y_z_setting)
elseif x_y_z_setting == 2 % x,y are switched!
    for TimePoint = [1:n_Markers]*3
        permutation_vector([TimePoint-2, TimePoint-1]) = permutation_vector([TimePoint-1, TimePoint-2]);
    end
    fprintf('\n        Axes setting: %d (x,y,z) = (2,1,3)', x_y_z_setting)
elseif x_y_z_setting == 3
    for TimePoint = [1:n_Markers]*3
        permutation_vector([TimePoint-1, TimePoint]) = permutation_vector([TimePoint, TimePoint-1]);
    end
    fprintf('\n        Axes setting: %d (x,y,z) = (1,3,2)', x_y_z_setting)
elseif x_y_z_setting == 4
    for TimePoint = [1:n_Markers]*3
        permutation_vector([TimePoint, TimePoint-2, TimePoint-1]) = permutation_vector([TimePoint-2, TimePoint-1, TimePoint]);
    end
    fprintf('\n        Axes setting: %d (x,y,z) = (2,3,1)', x_y_z_setting)
elseif x_y_z_setting == 5
    for TimePoint = [1:n_Markers]*3
        permutation_vector([TimePoint-1, TimePoint, TimePoint-2]) = permutation_vector([TimePoint-2, TimePoint-1, TimePoint]);
    end
    fprintf('\n        Axes setting: %d (x,y,z) = (3,1,2)', x_y_z_setting)
elseif x_y_z_setting == 6
    for TimePoint = [1:n_Markers]*3
        permutation_vector([TimePoint-2, TimePoint]) = permutation_vector([TimePoint, TimePoint-2]);
    end
    fprintf('\n        Axes setting: %d (x,y,z) = (3,2,1)', x_y_z_setting)
else %% SORTING OPTIONS MUST BE ADDED! THE INPUT MUST BE IN FORM [X,Y,Z] X LEADING TO SAGITTAL VIEW; Y LEADING TO FRONTAL VIEW
    msgbox('This x_y_z_setting does not exist!', 'Error', 'Error')
    error('This x_y_z_setting does not exist!')
end
DataKin = DataKin(:,permutation_vector);
if enable_COM
    if isempty(COM_subjtrial)
        warndlg('You chose to include the COM in video. But COM file is empty. The COM computation is probably disabled in main code.')
        enable_COM = 0;
    else
        COM_subjtrial = COM_subjtrial(:,permutation_vector(1:3));
    end
end
if nargin == 8
    COPdat = COPdat(:,permutation_vector(1:2));
end

fprintf('\n        The "Data" - Matrix contains %d rows',size(DataKin,1));

x_lim_max_mov = max(DataKin(1,[1:n_Markers]*3-2));
x_lim_min_mov = min(DataKin(1,[1:n_Markers]*3-2));
y_lim_max_mov = max(DataKin(1,[1:n_Markers]*3-1));
y_lim_min_mov = min(DataKin(1,[1:n_Markers]*3-1));
z_lim_max_mov = max(DataKin(1,[1:n_Markers]*3));
z_lim_min_mov = min(DataKin(1,[1:n_Markers]*3));

for i=1:skipFrames:size(DataKin, 1) % ****** Loopstart for Length of video ******
    x_lim_max_mov = max(x_lim_max_mov, max(DataKin(i,[1:n_Markers]*3-2)));
    y_lim_max_mov = max(y_lim_max_mov, max(DataKin(i,[1:n_Markers]*3-1)));
    z_lim_max_mov = max(z_lim_max_mov, max(DataKin(i,[1:n_Markers]*3)));
    
    x_lim_min_mov = min(x_lim_min_mov, min(DataKin(i,[1:n_Markers]*3-2)));
    y_lim_min_mov = min(y_lim_min_mov, min(DataKin(i,[1:n_Markers]*3-1)));
    z_lim_min_mov = min(z_lim_min_mov, min(DataKin(i,[1:n_Markers]*3)));
end


Space_on_sides = (x_lim_max_mov-x_lim_min_mov)*1.5;%/2;
Space_zmax = (z_lim_max_mov-z_lim_min_mov)/7;
Space_zmin = (z_lim_max_mov-z_lim_min_mov)/40;

x_lim_max_mov = x_lim_max_mov + Space_on_sides;
x_lim_min_mov = x_lim_min_mov - Space_on_sides;
y_lim_max_mov = y_lim_max_mov + Space_on_sides;
y_lim_min_mov = y_lim_min_mov - Space_on_sides;
z_lim_max_mov = z_lim_max_mov + Space_zmax;
z_lim_min_mov = z_lim_min_mov -  Space_zmin;


[ColorOptionsCell, ~] = optionsColoringVids(coloring_option, n_Markers);
nr_plot_lines = size(ColorOptionsCell, 2);





if vid_dim == 2
    h1=figure('Name',Title,'Position',[50,50,1000,700]);
    h1.Color = 'w';
    hold off
    box off
    
    mbprogress = msgbox('Video Progress: 0%%');
    for i=1:skipFrames:size(DataKin,1)
        set(findobj(mbprogress, 'Tag', 'MessageBox'), 'String', sprintf('Video Progress: %d%%', round(i/size(DataKin,1)*100)))
        figure(h1)
        subplot(1,2,1)
        for PlotLine = 1:nr_plot_lines % x-z plot
            plot(DataKin(i,ColorOptionsCell{1,PlotLine}*3-2),... % x
                DataKin(i,ColorOptionsCell{1,PlotLine}*3-0),... % z
                ColorOptionsCell{2,PlotLine}, ... % Marker/Linestyle
                'MarkerFaceColor',ColorOptionsCell{3,PlotLine}, ...
                'MarkerSize',     ColorOptionsCell{4,PlotLine})
            if PlotLine == 1
                hold on
            end
        end
        hold off
        xlim([x_lim_min_mov x_lim_max_mov]) % x lim
        ylim([z_lim_min_mov z_lim_max_mov]) % z lim
        title('Sagittal view')
        %legend(['time ' ,num2str(i/measurement_frequency),' s']);
        
        if enable_COM
            hold on
            plot(COM_subjtrial(i,1), COM_subjtrial(i,3), 'o', 'MarkerFaceColor','r','MarkerSize',5)
            if nargin == 8
                plot(COPdat(1:i,1), zeros(i, 1), 'o', 'MarkerFaceColor','r','MarkerSize',1)
            end
            hold off
        end
        
        subplot(1,2,2)
        for PlotLine = 1:nr_plot_lines % x-z plot
            plot(DataKin(i,ColorOptionsCell{1,PlotLine}*3-1),... % y
                DataKin(i,ColorOptionsCell{1,PlotLine}*3-0),... % z
                ColorOptionsCell{2,PlotLine}, ... % Marker/Linestyle
                'MarkerFaceColor',ColorOptionsCell{3,PlotLine}, ...
                'MarkerSize',     ColorOptionsCell{4,PlotLine})
            if PlotLine == 1
                hold on
            end
        end
        hold off
        xlim([y_lim_min_mov y_lim_max_mov]) % y lim
        ylim([z_lim_min_mov z_lim_max_mov]) % z lim
        title('Frontal view')
        %legend(['frame ',num2str(i)]);
        if enable_COM
            hold on
            plot(COM_subjtrial(i,2), COM_subjtrial(i,3), 'o', 'MarkerFaceColor','r','MarkerSize',5)
            if nargin == 8
                plot(COPdat(1:i,2), zeros(i, 1), 'o', 'MarkerFaceColor','r','MarkerSize',1)
            end
            hold off
        end
        pause(0.0001)
        
        frame = getframe(h1);
        writeVideo(writerObj,frame);
    end
    
    
elseif vid_dim == 3
    h1=figure('Name',Title,'Position',[50,50,500,700]);
    hold off
    box off
    set(gca,'YTickLabel',[])
    set(gca, 'TickLength',[0 0])
    h1.Color = 'w';
    az = 50;
    el = 15;
    
    mbprogress = msgbox('Video Progress: 0%%');
    for i=1:skipFrames:size(DataKin,1)
        set(findobj(mbprogress, 'Tag', 'MessageBox'), 'String', sprintf('Video Progress: %d%%', round(i/size(DataKin,1)*100)))
        figure(h1)
        
        FramesToRotation = 50;
        DegreesOfRotation = 10;
        if mod(i,FramesToRotation) == 0
            az = az + DegreesOfRotation;
        end
        
        for PlotLine = 1:nr_plot_lines % x-z plot
            plot3(DataKin(i,ColorOptionsCell{1,PlotLine}*3-2),... % x
                DataKin(i,ColorOptionsCell{1,PlotLine}*3-1),... % y
                DataKin(i,ColorOptionsCell{1,PlotLine}*3-0),... % z
                ColorOptionsCell{2,PlotLine}, ... % Marker/Linestyle
                'MarkerFaceColor',ColorOptionsCell{3,PlotLine}, ...
                'MarkerSize',     ColorOptionsCell{4,PlotLine})
            if PlotLine == 1
                hold on
            end
        end
        hold off
        xlim([x_lim_min_mov x_lim_max_mov])
        ylim([y_lim_min_mov y_lim_max_mov])
        zlim([z_lim_min_mov z_lim_max_mov])
        title(Title)
        xlabel('AP direction')
        ylabel('ML direction')
        %         title(['Azimut = ', num2str(az), '; Elevation = ', num2str(el)])
        %legend(['time ' ,num2str(i/measurement_frequency),' s']);
        
        
        
        if plotForcePlate % plots a grey forceplace near origin
            hold on
            lenFP = 300;
            xFP = [-lenFP; lenFP; lenFP; -lenFP];
            yFP = [-lenFP; -lenFP; lenFP; lenFP];
            zFP = zeros(length(yFP),1)-5;
            
            fill3(xFP, yFP, zFP, [.5 .5 .5])
            hold off
        end
        
        if enable_COM
            hold on
            plot3(COM_subjtrial(i,1), COM_subjtrial(i,2),COM_subjtrial(i,3), 'o', 'MarkerFaceColor','r','MarkerSize',5)
            if nargin == 8
                plot3(COPdat(1:i,1), COPdat(1:i,2),zeros(i, 1), 'o', 'MarkerFaceColor','r','MarkerSize',2)
            end
            hold off
        end
        
        view(az, el);
        pause(0.0001)
        
        frame = getframe(h1);
        writeVideo(writerObj,frame);
    end
end
close(writerObj);
close(h1)
close(mbprogress)
end
